% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explainer.R
\name{explainer.numeric}
\alias{explainer.numeric}
\title{Explain method for numeric data types}
\usage{
\method{explainer}{numeric}(
  X,
  xname = NULL,
  include.numeric = NULL,
  round.digit = 2,
  quant.seq = seq(0, 1, 0.2),
  trim = 0.05,
  ...
)
}
\arguments{
\item{X}{a numeric (or integer) data type}

\item{xname}{a placeholder for variable name}

\item{include.numeric}{a vector having strings which is also required along
with the default output. Can have values:
\itemize{
 \item \code{trimmed.means} for printing the trimmed mean after removing
 \code{trim} fraction of data from each side of x. \code{trim} can be passed
 as an parameter
 \item \code{skewness} for printing the skewness of the data.
 Use \code{?skreness} for more information
 \item \code{kurtosis} for printing
 the kurtosis of the data. Use \code{?kurtosis} for more information
}}

\item{round.digit}{number of decimal places required in the output.}

\item{quant.seq}{vector of fractions (0 to 1) for which the quantiles are
required \code{0.5} means median, \code{0} means smallest observation and
\code{1} means largest observation}

\item{trim}{the fraction (0 to 0.5) of observations to be trimmed from each
end of x before the mean is computed. Values of trim outside that range are
taken as the nearest endpoint. This only works if \code{include.numeric} has
a string 'trimmed.means'}

\item{...}{other parameters required}
}
\value{
Prints the following information on console:
\itemize{
 \item vector name
 \item type
 \item number of distinct values
 \item number of missing values
 \item mean
 \item sd (standard deviation)
 \item median
 \item quantiles based on \code{quant.seq} parameter
 \item other information based on \code{include.numeric}
 \item a box plot (only if number distinct numbers are > 2).
 If counts of all the factor levels are less than half of length of
 \code{x}, then the histogram is scaled with maximum of 50%. (look at
 \code{?consoleBoxplot} for how to read the table and histogram)
 \item a frequency table and histogram (only if number of distinct
 numbers are < 11)
 (look at \code{?freqTable} for how to read the table and histogram)
}
}
\description{
This is a \code{explainer} method for numeric vector.
}
\details{
This method removes all the missing values in \code{x} before computing the
summaries.
}
\examples{
explainer(mtcars$mpg)
explainer(mtcars$mpg, include.numeric = c('trimmed.means', 'skewness',
'kurtosis'), round.digit = 1, quant.seq = seq(0,1,0.1), trim = 0.05)

}
