% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{allocation_control}
\alias{allocation_control}
\title{Control Object for Allocation Methods}
\usage{
allocation_control(verbose = FALSE, bits = 256, tol = 1e-10, digits = 4)
}
\arguments{
\item{verbose}{Logical; if \code{TRUE}, detailed information will be printed to
the console by \link{allocate_fixn} and \link{allocate_prec}.}

\item{bits}{Number of bits of precision to use with \code{mpfr} objects in
internal calculations.}

\item{tol}{A small positive number for use in \link{allocate_prec}; if all strata
have \code{V <= tol}, regard the situation as one where no more allocation is
possible, even if target value \code{v0} has not yet been attained.}

\item{digits}{Number of decimals to display in output.}
}
\value{
An list of class \code{allocation_control}.
}
\description{
Additional arguments (controls) for \link{Allocation-Methods}.
}
\examples{
out1 = allocation_control()
out2 = allocation_control(verbose = TRUE, bits = 128, tol = 1e-8, digits = 2)

}
