% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poi_to_res.R
\name{poi_to_res}
\alias{poi_to_res}
\title{Convert an alignment position to residue position}
\usage{
poi_to_res(alignment, poi)
}
\arguments{
\item{alignment}{An alignment.}

\item{poi}{An alignment position.}
}
\value{
An integer vector of positions of the amino acid residues in the
  reference sequence.
}
\description{
This function converts an alignment position to a position in the frame of
the reference protein sequence, i.e., to the positions of the amino acids in
the first sequence of the alignment.
}
\examples{
align_ATM <- read_alignment('ATM')
align_ATM[, 1:5]

# Convert the positions of the first five alignment positions to residue positions
poi_to_res(align_ATM, 1:5)

}
