% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_curve.R
\name{effect_curve}
\alias{effect_curve}
\alias{effect_curve-class}
\alias{curve_est}
\alias{curve_est-class}
\title{Effect curve objects}
\arguments{
\item{\{treat\}}{the values of the treatment at which to evaluate the effect curve.}

\item{subset}{an optional logical expression indicating the subset of the subgroups for which to compute estimates. Can only be used when \code{by} was supplied to the original call to \code{\link[=adrf]{adrf()}}, and only to refer to variables defining subgroups.}

\item{x}{a \code{curve_est} object; the output of an \code{effect_curve} object call.}

\item{digits}{the number of digits to display.}

\item{\dots}{arguments passed to \code{\link[=print.data.frame]{print.data.frame()}}.}
}
\value{
A call to an \code{effect_curve} object returns a \code{curve_est} object, which is a \code{data.frame} containing a column for the treatment and a column for the effect curve estimates. \code{curve_est} objects have \code{print()}, \code{\link[=summary.curve_est]{summary()}}, \code{\link[=coef.curve_est]{ceof()}}, and \code{\link[=vcov.curve_est]{vcov()}} methods.
}
\description{
An \code{effect_curve} object is a function that takes in values of the treatment and produces estimates of the effect curve at those values. \code{effect_curve} objects are produces by \code{\link[=adrf]{adrf()}} and functions that modify effect curves, such as \code{\link[=amef]{amef()}}, \code{\link[=curve_contrast]{curve_contrast()}}, \code{\link[=reference_curve]{reference_curve()}}, and \code{\link[=curve_projection]{curve_projection()}}. The output of an \code{effect_curve} object is a \code{curve_est} object containing the effect curve estimates. This page describes \code{effect_curve} and \code{curve_est} objects.
\subsection{Usage}{

\preformatted{f <- adrf(x, ...)

f({treat}, subset = NULL)}
}
}
\details{
An \code{effect_curve} object contains a set of grid points on which the effect curve is initially evaluated. The effect curve estimates produced by a call to the \code{effect_curve} object are interpolated using 3rd-degree local polynomial regression with a Gaussian kernel and bandwidth equal to half the distance between grid points, unless they coincide with the grid points; this means the produced estimates are linear combinations of the grid point estimates.
}
\examples{
data("nhanes3lead")

fit <- lm(Math ~ poly(logBLL, 5) *
            (Male + Age + Race + PIR +
               Enough_Food),
          data = nhanes3lead)

# ADRF of logBLL on Math, unconditional
# inference
adrf1 <- adrf(fit, treat = "logBLL")

adrf1

# Compute estimates along the ADRF
adrf1(logBLL = c(0, 1, 2))

# Perform inference on the estimates
adrf1(logBLL = c(0, 1, 2)) |>
  summary()

# ADRF within groups defined by `Male`
adrf2 <- adrf(fit, treat = "logBLL",
              by = ~Male)

adrf2

# Estimates in both groups
adrf2(logBLL = c(0, 1, 2))

# Estimates in one group
adrf2(logBLL = c(0, 1, 2), subset = Male == 1)
}
\seealso{
\itemize{
\item \code{\link[=adrf]{adrf()}} for generating an effect curve
\item \code{\link[=summary.curve_est]{summary.curve_est()}} for performing inference on effect curve estimates
\item \code{\link[=plot.effect_curve]{plot.effect_curve()}} for plotting the effect curve
}
}
