% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_img.R
\name{access_img}
\alias{access_img}
\title{Produce an accessible image or chart.}
\usage{
access_img(
  img = last_plot(),
  alt = NULL,
  wid = NULL,
  ht = NULL,
  dpi = 300,
  css_class = NULL,
  css_id = NULL
)
}
\arguments{
\item{img}{The image to include as accessible HTML. Defaults to
'ggplot2::last_plot()'. Can be replaced with an image written to disc.}

\item{alt}{A character string describing the image for screen reader
accessibility.}

\item{wid}{Width of the image in pixels.}

\item{ht}{Height of the image in pixels.}

\item{dpi}{Resolution. Please see \code{?ggplot2::ggsave()} for details.}

\item{css_class}{Specify a css class selector for the image.}

\item{css_id}{Specify a css ID selector for the image.}
}
\value{
Inline HTML with the necessary structure for screen reader
accessibility.
}
\description{
Reads in an image and produces the HTML structure expected by web
accessibility checkers such as WAVE. Also works as a wrapper around
ggplot2 charts.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
# create a ggplot2 chart
ggplot(pressure, aes(temperature, pressure)) +
  geom_point()

# Use 'access_img()' to render the chart with alt text
access_img(alt = "Vapor Pressure of Mercury as a Function of Temperature")

# Create a png.
file.create(tempfile("some_img", fileext = ".png"))

# Read it from disk and include alt text
access_img("some_img.png", alt = "Some meaningful alt text")
\dontshow{
setwd(.old_wd)
}

}
