% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BB8copula.R
\name{BB8Copula}
\alias{BB8Copula}
\alias{surBB8Copula}
\alias{r90BB8Copula}
\alias{r270BB8Copula}
\title{Constructors for BB8 copulas}
\usage{
BB8Copula(param = c(1, 1))

surBB8Copula(param = c(1, 1))

r90BB8Copula(param = c(-1, -1))

r270BB8Copula(param = c(-1, -1))
}
\arguments{
\item{param}{The parameter \code{param} defines the copula through
\code{theta} and \code{delta}.}
}
\value{
One of the respective BB8 copula classes
(\linkS4class{BB8Copula}, \linkS4class{surBB8Copula},
\linkS4class{r90BB8Copula}, \linkS4class{r270BB8Copula}).
}
\description{
Constructs an object of the \linkS4class{BB8Copula} (survival
\code{sur}, 90 degree rotated \code{r90} and 270 degree rotated \code{r270})
family for given parameters.
}
\examples{

library(copula)

persp(BB8Copula(c(2, 0.9)), dCopula, zlim = c(0, 10))
persp(surBB8Copula(c(2, 0.9)), dCopula, zlim = c(0, 10))
persp(r90BB8Copula(c(-2, -0.9)), dCopula, zlim = c(0, 10))
persp(r270BB8Copula(c(-2, -0.9)), dCopula, zlim = c(0, 10))
}
\references{
Joe, H., (1997). Multivariate Models and Dependence Concepts.
Monogra. Stat. Appl. Probab. 73, London: Chapman and Hall.
}
\seealso{
See also \code{\link[=BB6Copula]{BB6Copula()}}, \code{\link[=BB7Copula]{BB7Copula()}},
\code{\link[=BB8Copula]{BB8Copula()}} and \code{\link[=joeBiCopula]{joeBiCopula()}} for further wrapper
functions to the \link[VineCopula:VineCopula-package]{VineCopula::VineCopula-package}.
}
