% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SplitFunctions.R
\name{SplitMatchProbability}
\alias{SplitMatchProbability}
\alias{LnSplitMatchProbability}
\title{Probability of matching this well}
\usage{
SplitMatchProbability(split1, split2)

LnSplitMatchProbability(split1, split2)
}
\arguments{
\item{split1, split2}{Logical vectors listing terminals in same order, such that
each terminal is identified as a member of the ingroup (\code{TRUE}) or outgroup
(\code{FALSE}) of the respective bipartition split.}
}
\value{
\code{SplitMatchProbability()} returns a numeric giving the proportion
of permissible non-trivial splits that divide the terminals into bipartitions
of the sizes given, that match as well as \code{split1} and \code{split2} do.

\code{LnSplitMatchProbability()} returns the natural logarithm of the
probability.
}
\description{
(\code{Ln})\code{SplitMatchProbability()}calculates the probability that two random
splits of the sizes provided will be at least as similar as the two
specified.
}
\examples{
split1 <- as.Splits(c(rep(TRUE, 4), rep(FALSE, 4)))
split2 <- as.Splits(c(rep(TRUE, 3), rep(FALSE, 5)))
SplitMatchProbability(split1, split2)
LnSplitMatchProbability(split1, split2)
}
\seealso{
Other split information functions: 
\code{\link{CharacterInformation}()},
\code{\link{SplitInformation}()},
\code{\link{TreesMatchingSplit}()},
\code{\link{UnrootedTreesMatchingSplit}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split information functions}
