% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapScores.R
\name{overlapScores}
\alias{overlapScores}
\title{Calculates Overlap Scores Between Two Sets of Topological Domains}
\usage{
overlapScores(a, reference, debug = getOption("TopDom.debug", FALSE))
}
\arguments{
\item{a, reference}{Topological domain (TD) set \eqn{A} and TD reference
set \eqn{R} both in a format as returned by \code{\link[=TopDom]{TopDom()}}.}

\item{debug}{If \code{TRUE}, debug output is produced.}
}
\value{
Returns a named list of class \code{TopDomOverlapScores}, where the names
correspond to the chromosomes in domain reference set \eqn{R}.
Each of these chromosome elements contains a data.frame with fields:
\itemize{
\item \code{chromosome}  - \eqn{D_{R,c}} character strings
\item \code{best_score}  - \eqn{D_{R,c}} numerics in \eqn{[0,1]}
\item \code{best_length} - \eqn{D_{R,c}} positive integers
\item \code{best_set}    - list of \eqn{D_{R,c}} index vectors
}

where \eqn{D_{R,c}} is the number of TDs in reference set \eqn{R} on
chromosome \eqn{c}.  If a TD in reference \eqn{R} is not a \code{"domain"},
then the corresponding \code{best_score} and \code{best_length} values are
\code{NA_real_} and \code{NA_integer_}, respectively, while \code{best_set} is an empty
list.
}
\description{
Calculates Overlap Scores Between Two Sets of Topological Domains
}
\details{
The \emph{overlap score}, \eqn{overlap(A', r_i)}, represents how well a
\emph{consecutive} subset \eqn{A'} of topological domains (TDs) in \eqn{A}
overlap with topological domain \eqn{r_i} in reference set \eqn{R}.
For each reference TD \eqn{r_i}, the \emph{best match} \eqn{A'_max} is
identified, that is, the \eqn{A'} subset that maximize
\eqn{overlap(A', r_i)}.
For exact definitions, see Page 8 in Shin et al. (2016).

Note that the overlap score is an asymmetric score, which means that
\code{overlapScores(a, b) != overlapScores(b, a)}.
}
\section{Warning - This might differ not be the correct implementation}{

The original TopDom scripts do not provide an implementation for
calculating overlap scores.  Instead, the implementation of
\code{TopDom::overlapScores()} is based on the textual description of
overlap scores provided in Shin et al. (2016).  It is not known if this
is the exact same algorithm and implementation as the authors of the
TopDom article used.
}

\examples{
library(tibble)
path <- system.file("exdata", package = "TopDom", mustWork = TRUE)

## Original count data (on a subset of the bins to speed up example)
chr <- "chr19"
pathname <- file.path(path, sprintf("nij.\%s.gz", chr))
data <- readHiC(pathname, chr = chr, binSize = 40e3, bins = 1:500)
print(data)

## Find topological domains using TopDom method for two window sizes
tds_5 <- TopDom(data, window.size = 5L)
tds_6 <- TopDom(data, window.size = 6L)

## Overlap scores (in both directions)
overlap_56 <- overlapScores(tds_6, reference = tds_5)
print(overlap_56)
print(as_tibble(overlap_56))

overlap_65 <- overlapScores(tds_5, reference = tds_6)
print(overlap_65)
print(as_tibble(overlap_65))

}
\references{
\itemize{
\item Shin et al.,
TopDom: an efficient and deterministic method for identifying
topological domains in genomes,
\emph{Nucleic Acids Research}, 44(7): e70, April 2016.
doi: 10.1093/nar/gkv1505,
PMCID: \href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4838359/}{PMC4838359},
PMID: \href{https://pubmed.ncbi.nlm.nih.gov/26704975/}{26704975}
}
}
\seealso{
\link{TopDom}.
}
\author{
Henrik Bengtsson - based on the description in Shin et al. (2016).
}
