% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToothCore.R
\name{ToothCore}
\alias{ToothCore}
\title{ToothCore}
\usage{
ToothCore(
  out.sur = out.sur,
  inn.sur = inn.sur,
  num.sect = 61,
  bio.len,
  clean_int_out_O = TRUE,
  clean_int_out_I = TRUE,
  param1_out = 0.5,
  radius.fact_out = 2.5,
  param1_inn = 0.5,
  radius.fact_inn = 2.5,
  npovs = 100,
  num.points = 500,
  start = 0.2,
  end = 0.8,
  curved = FALSE,
  print.progress = TRUE
)
}
\arguments{
\item{out.sur}{object of class mesh3d}

\item{inn.sur}{object of class mesh3d}

\item{num.sect}{number of sections}

\item{bio.len}{length of the selected region of interest along with extracting the digital section}

\item{clean_int_out_O}{logical if TRUE the outer section will be cleaned by using spherical flipping}

\item{clean_int_out_I}{logical if TRUE the inner section will be cleaned by using spherical flipping}

\item{param1_out}{numeric parameter for clean_int_out_O spherical flipping operator (how much the section will be deformed)}

\item{radius.fact_out}{logical if TRUE the inner section will be cleaned by using spherical flipping}

\item{param1_inn}{numeric parameter for clean_int_out_I spherical flipping operator (how much the section will be deformed)}

\item{radius.fact_inn}{logical if TRUE the inner section will be cleaned by using spherical flipping}

\item{npovs}{numeric: number of points of view defined around the section}

\item{num.points}{number of equiengular points to be defined on each section}

\item{start}{percentage of the mechanical length from which the first section is defined}

\item{end}{percentage of the mechanical length from which the last section is defined}

\item{curved}{logical: if TRUE the cutting planes will follow the mesh curvature (beta version)}

\item{print.progress}{logical: if TRUE a progress bar is printed to the screen}
}
\value{
out3D num.pointsx3xnum.sect array of the external outlines

inn3D num.pointsx3xnum.sect array of the internal outlines

out3D num.pointsx2xnum.sect array of the external outlines

inn3D num.pointsx2xnum.sect array of the internal outlines

mech_length mechanical length of the long bone

start percentage of the mechanical length from which the first section is defined

end percentage of the mechanical length from which the last section is defined
}
\description{
Tool to build 3D and 2D cross sections
}
\examples{
\donttest{
data("URI1_tooth")
require(morphomap)
require(Morpho)
require(rgl)
Enamel<-URI1_tooth$mesh1
Dentin<-URI1_tooth$mesh2
Pulp<-URI1_tooth$mesh3
outline<-URI1_tooth$outline
set<-URI1_tooth$set

#Unrolling the crown
AlignMeshes<-ToothAlignment(mesh1=Enamel,mesh2=Dentin,mesh3=Pulp,set,outline,analyse = "c")
#Virtual sectioning dentine-pulp
External<-AlignMeshes$almesh1$mesh
Internal<-AlignMeshes$almesh2$mesh
#Define 16 cross-sections from the 30\% to the 90\% along the crown
Core<-ToothCore(External,Internal,num.points = 1000,num.sect =16,
                bio.len = AlignMeshes$length,start=0.3,end=0.9)

plot3d(morphomapArray2matrix(Core$"out3D"),aspect=FALSE,xlab="x",ylab="y",zlab="z")
plot3d(morphomapArray2matrix(Core$"inn3D"),aspect=FALSE,add=TRUE)
wire3d(AlignMeshes$almesh2$mesh,col="white")
wire3d(AlignMeshes$almesh1$mesh,col="violet")

#Unrolling the rooth
AlignMeshes<-ToothAlignment(mesh1=Enamel,mesh2=Dentin,mesh3=Pulp,set,outline,analyse = "r")
#Virtual sectioning dentine-pulp
External<-AlignMeshes$almesh2$mesh
Internal<-AlignMeshes$almesh3$mesh
#Define 16 cross-sections from the 10\% to the 50\% along the root
Core<-ToothCore(External,Internal,num.points = 1000,num.sect =16,
                bio.len = AlignMeshes$length,start=0.1,end=0.5)

plot3d(morphomapArray2matrix(Core$"out3D"),aspect=FALSE,xlab="x",ylab="y",zlab="z")
plot3d(morphomapArray2matrix(Core$"inn3D"),aspect=FALSE,add=TRUE)
wire3d(AlignMeshes$almesh3$mesh,col="red")
wire3d(AlignMeshes$almesh2$mesh,col="lightblue")
wire3d(AlignMeshes$almesh1$mesh,col="white")
}
}
\author{
Antonio Profico; Mathilde Augoyard
}
