% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{jsd}
\alias{jsd}
\title{Jensen-Shannon divergence}
\usage{
jsd(M, pseudocount = 1e-06, normalizeCounts = FALSE)
}
\arguments{
\item{M}{a probability distribution matrix, e.g., normalized transcript compatibility counts.}

\item{pseudocount}{a small number to avoid division by zero errors.}

\item{normalizeCounts}{logical, whether to attempt to normalize by dividing by the column sums. Set to \code{TRUE} if this is, e.g., a count matrix.}
}
\value{
A Jensen-Shannon divergence-based distance matrix.
}
\description{
Calculates a distance matrix from a matrix of probability distributions using
Jensen-Shannon divergence. Adapted from \url{https://enterotype.embl.de/enterotypes.html#dm}.
}
\examples{
set.seed(42)
M <- matrix(rpois(100, lambda=100), ncol=5)
colnames(M) <- paste0("sample", 1:5)
rownames(M) <- paste0("gene", 1:20)
Mnorm <- apply(M, 2, function(x) x/sum(x))
Mjsd <- jsd(Mnorm)
# equivalently
Mjsd <- jsd(M, normalizeCounts=TRUE)
Mjsd
plot(hclust(Mjsd))
  
}
