% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneexpression.R
\name{counts2fpkm}
\alias{counts2fpkm}
\title{Fragments per kilobase per million}
\usage{
counts2fpkm(x, length, log = FALSE, prior.count = 0.25)
}
\arguments{
\item{x}{a matrix of counts}

\item{length}{a vector of length \code{nrow(x)} giving length in bases}

\item{log}{logical, if \code{TRUE}, then \code{log2} values are returned.}

\item{prior.count}{average count to be added to each observation to avoid 
taking log of zero. Used only if \code{log=TRUE}.}
}
\value{
A matrix of FPKM values.
}
\description{
Takes a count matrix and a vector of gene lengths and returns an optionally \code{log2}-transformed FPKM matrix. Modified from edgeR.
}
\examples{
\dontrun{
library(readr)
library(dplyr)
countdata <- read_csv("http://files.figshare.com/2439061/GSE37704_featurecounts.csv") 
counts <- countdata \%>\% select(countdata, starts_with("SRR")) \%>\% as.matrix
counts2fpkm(counts, countdata$length)
}
  
}
