% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leastcore.R
\name{leastcore}
\alias{leastcore}
\title{Least core}
\usage{
leastcore(v, binary = FALSE, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
This function returns four outputs:

\item{\code{t}}{The excess value that defines the least core.}

\item{\code{sat}}{The positions (binary order positions if \code{binary=TRUE}; lexicographic order positions otherwise) of the saturated coalitions, as a vector.}

\item{\code{x}}{A least core allocation, as a vector.}

\item{\code{vt}}{The game whose core is the least core of \code{v}, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.}
}
\description{
Given a game, this function computes its least core.
}
\details{
Given a game \eqn{v\in G^N} and a number \eqn{\varepsilon \in \mathbb{R}}, the \eqn{\varepsilon}-core of \eqn{v} is defined as
\deqn{C_{\varepsilon}(v)= \{ x\in \mathbb{R}^n : x(N)=v(N) \text{ and } x(S) \ge v(S)-\varepsilon \ \forall S \in 2^N \setminus \{\emptyset,N\} \},}
where \eqn{x(S)=\sum_{i\in S} x_i}.
The least core of \eqn{v} is defined as the intersection of all non-empty \eqn{\varepsilon}-cores of \eqn{v}:
\deqn{LC(v) = \{ \bigcap_{\varepsilon \in \mathbb{R} \ : \ C_{\varepsilon}(v) \neq \emptyset} C_{\varepsilon}(v) \}.}

The implementation of this function is based on the algorithm presented in Derks and Kuipers (1997) and on the MATLAB package WCGT2005 by J. Derks.
}
\examples{
v <- c(0,0,0,0,10,40,30,60,10,20,90,90,90,130,160)
( vt <- leastcore(v)$vt )
# Plotting the core and the least core of v:
plotcoresets(games = rbind(v,vt), imputations = FALSE)

# What if the game is a cost game?
cost.v <- c(2,2,2,3,4,4,5) # characteristic function of the cost game
-leastcore(-cost.v)$t # the excess value that defines the least core of cost.v
leastcore(-cost.v)$sat # the saturated coalitions
-leastcore(-cost.v)$x # a least core allocation
-leastcore(-cost.v)$vt # the cost game whose core is the least core of cost.v
}
\references{
Derks, J. & Kuipers, J. (1997). Implementing the simplex method for computing the prenucleolus of transferable utility games.

Software by J. Derks (Copyright 2005 Universiteit Maastricht, dept. of Mathematics), available in package \emph{MatTuGames},

            \url{https://www.shorturl.at/i6aTF}.
}
\seealso{
\link{excesses}, \link{nucleoluspcvalue}, \link{nucleolusvalue}, \link{prenucleolusvalue}
}
