#' @title Binary order to lexicographic order
#' @description Given a characteristic function in binary order, this function returns the characteristic function in lexicographic order.
#' @param v A characteristic function, as a vector in binary order.
#' @return The characteristic function, as a vector in lexicographic order.
#' @details The binary order position of a coalition \eqn{S\in 2^N} is given by \eqn{\sum_{i\in S} 2^{i-1}}. Lexicographic order arranges coalitions in ascending order according to size, and applies lexicographic order to break ties among coalitions of the same size.
#' @examples
#' v <- seq(1:31)
#' bin2lex(v)
#' lex2bin(bin2lex(v))==v
#' @seealso \link{codebin2lex}, \link{codelex2bin}, \link{lex2bin}
#' @export

bin2lex <- function(v) {

  ################################
  ### Comprobación datos entrada###
  ################################

  nC <- length(v) # Número de coaliciones.
  n <- log(nC + 1) / log(2) # Número de jugadores.
  if (n > floor(n)) {
    stop("'v' must have length 2^n-1 for some n.")
  }

  if (n <= 2) # Si el juego es de dos jugadores, ambos juegos coinciden.
    {
      return(v)
    }

  ################################
  ##### Creación de variables######
  ################################

  vnew <- v # v en orden binario.

  ################################
  ###### Cuerpo de la función######
  ################################

  # Las dos primeras coaliciones y las dos últimas coinciden.
  for (ii in 3:(nC - 3))
  {
    # Paso de código binario a lexicográfico.
    vnew[codebin2lex(n, ii)] <- v[ii]
  }

  ################################
  ###### Salidas de la función#####
  ################################

  return(vnew)
} # Fin de la función.
