
single_run <- function(X, reps=3, maxi=1000)
{
DFcols <- reps + 6
DFnames <- c("ICA","Scores", "Weight", "Strategy", "Oldname", "Statistic", paste("Rep", 1:reps, sep="."))

DF <- data.frame(matrix(0,ncol=DFcols, nrow=40))
colnames(DF) <- DFnames
DF$ICA <- rep(c("JADE","FOBI","FastICA", "S"), 10)
DF$Scores <- c(rep(c("Identity","Rank","VdW"), c(8,8,4)),rep(c("Identity","Rank","VdW"), c(8,8,4)))
DF$Weight <- c(rep(c("Gauss","Laplace","Gauss","Laplace","Gauss"), each=4),rep(c("Gauss","Laplace","Gauss","Laplace","Gauss"), each=4))
DF$Strategy <- rep(c("bootstrap","permutation"), each=20)
DF$Oldname <- rep(c("C1","C2","C3","C4","C5", "P1", "P2","P3","P4","P5"), each=4)

# C1 test boot

ind <- 1

res <- tryCatch({ICAtestGauss_jade(X, n.boot = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestGauss_fobi(X, n.boot = reps)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestGauss_fICA(X, n.boot = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestGauss_S(X, n.boot = reps)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
# C2 Test boot

res <- tryCatch({ICAtestLap_jade(X, n.boot = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestLap_fobi(X, n.boot = reps)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestLap_fICA(X, n.boot = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestLap_S(X, n.boot = reps)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1

# C3 Rank Gauss boot

res <- tryCatch({ICAtestRankGauss_jade(X, n.boot = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestRankGauss_fobi(X, n.boot = reps)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestRankGauss_fICA(X, n.boot = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestRankGauss_S(X, n.boot = reps)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1

# C4 Rank Lap boot

res <- tryCatch({ICAtestRankLap_jade(X, n.boot = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestRankLap_fobi(X, n.boot = reps)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestRankLap_fICA(X, n.boot = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestRankLap_S(X, n.boot = reps)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1

# C5 vdw Gauss boot

res <- tryCatch({ICAtestRankvdW_jade(X, n.boot = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestRankvdW_fobi(X, n.boot = reps)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestRankvdW_fICA(X, n.boot = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1
res <- tryCatch({ICAtestRankvdW_S(X, n.boot = reps)}, error = function(e) {list(T = NA, Tboot = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tboot
ind <- ind+1

# P1

res <- tryCatch({ICAtestGauss_jade_perm(X, n.perm = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestGauss_fobi_perm(X, n.perm = reps)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestGauss_fICA_perm(X, n.perm = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestGauss_S_perm(X, n.perm = reps)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1

# P2 Test perm

res <- tryCatch({ICAtestLap_jade_perm(X, n.perm = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestLap_fobi_perm(X, n.perm = reps)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestLap_fICA_perm(X, n.perm = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestLap_S_perm(X, n.perm = reps)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1

# P3 Rank Gauss perm

res <- tryCatch({ICAtestRankGauss_jade_perm(X, n.perm = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestRankLap_fobi_perm(X, n.perm = reps)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestRankGauss_fICA_perm(X, n.perm = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestRankGauss_S_perm(X, n.perm = reps)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1

# P4 

res <- tryCatch({ICAtestRankLap_jade_perm(X, n.perm = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestRankLap_fobi_perm(X, n.perm = reps)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestRankLap_fICA_perm(X, n.perm = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestRankLap_S_perm(X, n.perm = reps)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1

# P5

res <- tryCatch({ICAtestRankvdW_jade_perm(X, n.perm = reps, maxiter = maxi)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestRankvdW_fobi_perm(X, n.perm = reps)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestRankvdW_fICA_perm(X, n.perm = reps,maxiter = maxi)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm
ind <- ind+1
res <- tryCatch({ICAtestRankvdW_S_perm(X, n.perm = reps)}, error = function(e) {list(T = NA, Tperm = rep(NA, reps), pval = NA)})
DF[ind, 6] <- res$T
DF[ind, -(1:6)] <- res$Tperm

DF
}