% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTemporal.R
\name{plotTemporal}
\alias{plotTemporal}
\title{Plotting wind behaviour time series and summary statistics at given point
locations}
\usage{
plotTemporal(data, storm, var = "speed")
}
\arguments{
\item{data}{time series generated with \code{temporalBehaviour} with \code{product=TS}
input}

\item{storm}{list of characters. Storm names. The storm must be available in
\code{data} input. It can also be a vector of integer corresponding to the
indices of storms stored in \code{data}input.}

\item{var}{character. Represent the type of variable to plot. Must be either
\code{speed} or \code{direction}. Default value is set to \code{speed}.}
}
\value{
null
}
\description{
Plotting wind behaviour time series and summary statistics at given point
locations
}
\examples{
\donttest{
sds <- defStormsDataset()
st <- defStormsList(sds = sds, loi = "Vanuatu", names = "PAM", verbose = 0)

df <- data.frame(x = c(168.33, 167.17), y = c(-17.73, -15.53))
rownames(df) <- c("Port_Vila", "Luganville")

# Generate temporal series of wind on the points
TS <- temporalBehaviour(st, points = df, product = "TS", tempRes = 30, verbose = 0)

# Plot temporal series of wind speed
plotTemporal(data=TS, storm="PAM")

# Plot temporal series of wind direction
plotTemporal(data=TS, storm="PAM", var='direction')
}
}
