% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_plotBoxplot.R
\name{plotBoxplot}
\alias{plotBoxplot}
\title{Plot \code{Boxplot}}
\usage{
plotBoxplot(
  slick,
  PI = NULL,
  type = c("boxplot", "violin", "both", "all"),
  byOM = FALSE,
  ncol = 4,
  MP_label = "Code",
  PI_label = "Code"
)
}
\arguments{
\item{slick}{A \code{\link[=Slick-class]{Slick-class()}} object}

\item{PI}{Numeric value indicating the Performance Indicator(s) to plot from the \code{Boxplot-class} object.
If NULL, it will facet_wrap all PIs}

\item{type}{Character string specifying the plot type.}

\item{byOM}{Logical. Facet the plots by operating model? PI must be a single value}

\item{ncol}{Numeric. Number of columns}

\item{MP_label}{Label to use for the MPs. Either \code{Code} or \code{Label}.
\code{Description} works as well, but you probably don't want to do that.}

\item{PI_label}{Label to use for the PIs. Either \code{Code} or \code{Label}.
\code{Description} works as well, but you probably don't want to do that.}
}
\value{
A \code{ggplot2} object, or a list of \code{ggplot2} objects
}
\description{
Plots boxplot, violin plot, or a combined box+violin plot for information stored
in a \linkS4class{Boxplot} object
}
\examples{
# Generate dummy values
nsim <- 10
nOM <- 2
nMP <- 4
nPI <- 3

values <- array(NA, dim=c(nsim, nOM, nMP, nPI))
pi_means <- runif(nPI, 5, 50)
for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[,om, mp, pi] <- rlnorm(nsim, log(pi_means[pi]), 0.4)
    }
  }
}

# Create and populate Object
boxplot <- Boxplot(Code=c('PI1', 'PI2', 'PI3'),
                   Label=c('Performance Indicator 1',
                           'Performance Indicator 2',
                           'Performance Indicator 3'),
                   Description = c('This is the description for PI 1',
                                   'This is the description for PI 2',
                                   'This is the description for PI 3'),
                   Value=values)

# Check
Check(boxplot)

# Add to `Slick` object
slick <- Slick()
Boxplot(slick) <- boxplot

# Plots
plotBoxplot(slick)

plotBoxplot(slick, type='violin')

plotBoxplot(slick, byOM=TRUE)

plotBoxplot(slick, 2, type='both', byOM=TRUE)

}
