% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{SRC}
\alias{SRC}
\title{Compute the slope of the reliability curve}
\usage{
SRC(
  dt,
  f = c("below", "normal", "above"),
  o = tc_cols(dt),
  by = by_cols_terc_fc_score_sp(dt),
  pool = c("year", space_dimvars(dt)),
  dim.check = TRUE
)
}
\arguments{
\item{dt}{Data table containing the predictions.}

\item{f}{column names of the prediction.}

\item{o}{column name of the observations (either in obs_dt, or in dt if obs_dt = NULL). The observation column needs to
contain -1 if it falls into the first category (corresponding to \code{fcs[1]}), 0 for the second and 1 for the third category.}

\item{by}{column names of grouping variables, all of which need to be columns in dt.
Default is to group by all instances of month, season, lon, lat, system and lead_time that are columns in dt.}

\item{pool}{column name(s) for the variable(s) along which is averaged, typically just 'year'.}

\item{dim.check}{Logical. If TRUE, the function tests whether the data table contains only one row per coordinate-level, as should be the case.}
}
\value{
A data table with the scores

@examples
dt = data.table(below = c(0.5,0.3,0),
normal = c(0.3,0.3,0.7),
above = c(0.2,0.4,0.3),
tc_cat = c(-1,0,0),
year = 1:3)
print(dt)
SRC(dt)
}
\description{
Values below 1 indicate a lack of resolution or overconfidence, 1 is perfect, above means underconfident.
This score requires more datapoints to be robust than e.g. the ignorance or Brier score. Therefore the default is to pool the data in space and only calculate one score per season.
}
