% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Hinge}
\alias{Hinge}
\title{Hinge}
\usage{
Hinge(YMAT, DIM = 2L, EPSILON = 1e-05, returnAll = FALSE, rho = 1)
}
\arguments{
\item{YMAT}{Data. First column is -1 or 1 indicating the class of each observation. The remaining columns are the coordinates of the data points.}

\item{DIM}{Dimension of data. Default value is 2.}

\item{EPSILON}{Small perturbation value needed in calculation. Default value is 0.00001.}

\item{returnAll}{Return all of theta values? Boolean with default value FALSE.}

\item{rho}{Sensitivity factor to adjust the level of change in the SVM fit when a new observation is added. Default value 1.0}
}
\value{
A list containing:
\item{THETA}{SVM fit parameters.}
\item{NN}{Number of observation points in YMAT.}
\item{DIM}{Dimension of data.}
\item{THETA_list}{THETA at each iteration (new point observed) as YMAT is fed into the algorithm one data point at a time.}
\item{OMEGA}{Intermediate value OMEGA at each iteration (new point observed).}
}
\description{
Fit SVM with Hinge loss function.
}
\examples{
YMAT <- generateSim(10^4)
h1<-Hinge(YMAT$YMAT,returnAll=TRUE)
}
