% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIS_combo.R
\name{SIS_combo}
\alias{SIS_combo}
\title{SIS combo}
\usage{
SIS_combo(X, M, C, time, status, p_adjust_option = "BH", thres = 0.05)
}
\arguments{
\item{X}{An n by p matrix of exposures.}

\item{M}{An n by p matrix of mediators.}

\item{C}{An n by p matrix of covariates.}

\item{time}{A vector of survival time of samples.}

\item{status}{A vector of status indicator: 0=alive, 1=dead.}

\item{p_adjust_option}{The method for multiple correction. Option include q-value, holm, hochberg, hommel, bonferroni, BH, BY,
and fdr. Default is BH.}

\item{thres}{Threshold for determining significance.}
}
\value{
A list which includes the final p-value matrix (p_final_matrix), adjusted p-value matrix (p_adjusted_matrix) and mediation-exposure matrix (p_med_matrix).
}
\description{
A function for SIS + SIS combo.
}
\examples{
data(example_dat)
surv_dat <- example_dat$surv_dat
SIS_combo(example_dat$X, example_dat$M, example_dat$C, time = surv_dat$time,
status = surv_dat$status)


}
