% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_selection.R
\name{scent_select}
\alias{scent_select}
\title{Feature Selection by Gene Heterogeneity}
\usage{
scent_select(
  expr,
  bit_threshold = NULL,
  count_threshold = NULL,
  perc_threshold = NULL,
  unit = "log2",
  normalise = TRUE,
  transpose = FALSE
)
}
\arguments{
\item{expr}{A matrix of gene expression data. Cells should be represented
as rows and genes should be represented as columns.}

\item{bit_threshold}{The threshold for the amount of bits of information a
gene must add to be selected as a feature. Only one threshold can be used
at a time.}

\item{count_threshold}{A number represented how many of the most
heterogeneous cells should be selected. Only one threshold can be used at
a time.}

\item{perc_threshold}{The percentile of the hetergeneity distribution above
which a gene should be to be selected as a feature.}

\item{unit}{The units to be used when calculating entropy.}

\item{normalise}{A logical value representing whether the gene counts
should be normalised into a probability distribution.}

\item{transpose}{A logical value representing whether the matrix should
be transposed before having any operations computed on it.}
}
\value{
A matrix of gene expression values where genes with low
heterogeneity have been removed.
}
\description{
Feature Selection by Gene Heterogeneity
}
\examples{
#Creating Data
gene1 <- c(0,0,0,0,1,2,3)
gene2 <- c(5,5,3,2,0,0,0)
gene3 <- c(2,0,2,1,3,0,1)
gene4 <- c(3,3,3,3,3,3,3)
gene5 <- c(0,0,0,0,5,0,0)
gene_counts <- matrix(c(gene1,gene2,gene3,gene4,gene5), ncol = 5)
rownames(gene_counts) <- paste0("cell",1:7)
colnames(gene_counts) <- paste0("gene",1:5)

#Performing Feature Selection
scent_select(gene_counts, bit_threshold = 0.85)
scent_select(gene_counts, count_threshold = 2)
scent_select(gene_counts, perc_threshold = 0.25)
}
