% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_maxcor.R
\name{calc.maxcor}
\alias{calc.maxcor}
\title{Calculate maximum correlation}
\usage{
calc.maxcor(x1, x2)
}
\arguments{
\item{x1}{Named matrix 1}

\item{x2}{Named matrix 2}
}
\value{
A vector of maximum absolute correlations
}
\description{
Calculates the maximum absolute correlation between two matrices along the
columns
}
\details{
This function calculates the maximum absolute correlation for each column of
\code{x2} against each column of \code{x1}. The matrices are named and if
the names overlap between \code{x1} and \code{x2}, the correlation between
the same named entries is set to zero.
}
\examples{
x1 <- matrix(rnorm(500), 100, 5)
x2 <- x1 + matrix(rnorm(500), 100, 5)
colnames(x1) <- c("A", "B", "C", "D", "E")
colnames(x2) <- c("A", "B", "C", "D", "E")
cor(x1, x2)
calc.maxcor(x1, x2)

}
