% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_rulsif.R
\name{dr_rulsif}
\alias{dr_rulsif}
\title{Density-ratio SDM estimation with RuLSIF}
\usage{
dr_rulsif(
  presence_data = NULL,
  background_data = NULL,
  projection_data = NULL,
  sigma = 10^seq(-3, 1, length.out = 9),
  lambda = 10^seq(-3, 1, length.out = 9),
  alpha = 0.1,
  kernel_num = 100,
  verbose = FALSE,
  method,
  object = NULL
)
}
\arguments{
\item{presence_data}{dataframe of covariates}

\item{background_data}{dataframe of covariates}

\item{projection_data}{dataframe of covariates}

\item{sigma}{Sigma parameter for RuLSIF. Default is the RuLSIF default.}

\item{lambda}{Lambda parameter for RuLSIF. Default is the RuLSIF default.}

\item{alpha}{Relative parameter.  Defaults to RuLSIF default.}

\item{kernel_num}{kernel_number for RuLSIF. Default is the RuLSIF default.}

\item{method}{one of either "fit" or "predict"}

\item{object}{fitted object returned by a dr_... function. Only needed when method = "predict"}
}
\description{
dr_rulsif is an internal function for density-ratio estimation with RuLSIF \insertCite{Kanamori2009-pz,Yamada2013-ra}{S4DM}.
}
\references{
\insertAllCited{}
}
\keyword{internal}
