% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkf_CI.R
\name{linkf_CI}
\alias{linkf_CI}
\title{Confidence intervals for the frequency of host-symbiont association}
\usage{
linkf_CI(
  freqfun = "paco",
  x,
  fx,
  c.level = 95,
  barplot = TRUE,
  col.bar = "lightblue",
  col.ci = "darkblue",
  y.lim = NULL,
  ...
)
}
\arguments{
\item{freqfun}{Global-fit method. Options are \code{"geoD"}
(Geodesic Distances), \code{"paco"} (PACo) or \code{"paraF"}
(ParaFit). It should be the same method used to obtain \code{"fx"}.}

\item{x}{Matrix produced with \code{\link[=prob_statistic]{prob_statistic()}}
for\code{"geoD"} (Geodesic Distances),
\code{"paco"} (PACo) or \code{"paraF"} (ParaFit).}

\item{fx}{Vector of statistics produced with
\code{\link[=max_cong]{max_cong()}} or
\code{\link[=max_incong]{max_incong}} for\code{"geoD"}
(Geodesic Distances), \code{"paco"} (PACo) or \code{"paraF"}
(ParaFit).}

\item{c.level}{Confidence interval level. Default is \code{95} (95\\\%).}

\item{barplot}{Default is \code{"TRUE"}, plots the distribution and
confidence intervals of the frequencies.}

\item{col.bar}{A vector of colors for the bars or bar components.
By default, \code{"lightblue"} is used.}

\item{col.ci}{A vector of colors for the confidence intervals arrows.
By default, \code{"darkblue"} is used.}

\item{y.lim}{Limits for the y axis.}

\item{...}{Any graphical option admissible in
\code{\link[=barplot]{barplot()}}}
}
\value{
A dataframe with associations information (columns 1 and 2), the
observed value of the frequencies for these associations (column 3),
the mean, the minimum and the maximum value of the frequencies
(columns 4, 5 and 6) obtained with the sets of posterior
probability trees.
}
\description{
From the matrix obtained in \code{\link[=prob_statistic]{prob_statistic()}},
compute the confidence intervals for the frequencies (or residual/corrected
frequencies) of the host-symbiont associations using a set of pairs of
posterior probability trees of host and symbiont.
}
\examples{
\donttest{
data(nuc_cp)
N = 10 #for the example, we recommend 1e+4 value
n = 8
# Maximizing incongruence
NPi <- max_incong(np_matrix, NUCtr, CPtr, n, N, method = "paco",
                 symmetric = FALSE, ei.correct = "sqrt.D",
                 percentile = 0.99, diff.fq = TRUE,
                 strat = "parallel", cl = 8)
# Loaded directly from dataset
# THSi <- trimHS_maxI(N, np_matrix, n)
# pp_treesPACo_incong <- prob_statistic(ths = THSi, np_matrix,
#                        NUC_500tr[1:5], CP_500tr[1:5], freqfun = "paco",
#                        NPi, symmetric = FALSE, ei.correct = "sqrt.D",
#                        percentile = 0.99, diff.fq = TRUE, res.fq = FALSE,
#                        below.p = FALSE, strat = "parallel", cl = 8)
LFci <- linkf_CI (freqfun = "paco", x = pp_treesPACo_incong, fx = NPi,
                  c.level = 95, ylab = "Observed - Expected frequency")
}

}
