% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainExtLasso.R
\name{tuneandtrainExtLasso}
\alias{tuneandtrainExtLasso}
\title{Tune and Train External Lasso}
\usage{
tuneandtrainExtLasso(
  data,
  dataext,
  estperf = FALSE,
  maxit = 120000,
  nlambda = 100
)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{dataext}{A data frame containing the external validation data. The first column should be the response variable 
(factor), and the remaining columns should be the predictor variables.}

\item{estperf}{A logical value indicating whether to use internal tuning with external validation (\code{TRUE}) 
or external tuning (\code{FALSE}). Default is \code{FALSE}.}

\item{maxit}{An integer specifying the maximum number of iterations. Default is 120000.}

\item{nlambda}{An integer specifying the number of lambda values to use in the Lasso model. Default is 100.}
}
\value{
A list containing the following components:
  \itemize{
    \item \code{best_lambda}: The optimal lambda value determined during the tuning process.
    \item \code{best_model}: The trained Lasso model using the selected lambda value.
    \item \code{est_auc}: The AUC value evaluated on the external dataset. This is only returned when \code{estperf = TRUE}, 
      providing a conservative (slightly pessimistic) estimate of the model's performance.
    \item \code{active_set_Train}: The number of active coefficients (non-zero) in the model trained on the training dataset.
  }
}
\description{
This function tunes and trains a Lasso classifier using the \code{glmnet} package. 
It provides two strategies for tuning hyperparameters based on the \code{estperf} argument:
\itemize{
  \item When \code{estperf = FALSE} (default): Hyperparameters are tuned using the external validation dataset. 
        The lambda value that gives the highest AUC on the external dataset is selected as the best model.
        However, no AUC value is returned in this case, as per best practices.
  \item When \code{estperf = TRUE}: Hyperparameters are tuned internally using the training dataset. 
        The model is then validated on the external dataset to provide a conservative (slightly pessimistic) AUC estimate.
}
}
\examples{
# Load sample data
data(sample_data_train)
data(sample_data_extern)

# Example usage with external tuning (default)
result <- tuneandtrainExtLasso(sample_data_train, sample_data_extern, maxit = 120000, nlambda = 100)
print(result$best_lambda)
print(result$best_model)
print(result$active_set_Train)

# Example usage with internal tuning and external validation
result_internal <- tuneandtrainExtLasso(sample_data_train, sample_data_extern, 
  estperf = TRUE, maxit = 120000, nlambda = 100)
print(result_internal$best_lambda)
print(result_internal$best_model)
print(result_internal$est_auc)
print(result_internal$active_set_Train)
}
