% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/australia.R
\name{australia}
\alias{australia}
\title{australia}
\usage{
australia(
  site,
  variable = "discharge",
  start_date = NULL,
  end_date = NULL,
  sites = FALSE,
  ...
)
}
\arguments{
\item{site}{Australian gauge number}

\item{variable}{Character. Either \code{stage} or \code{discharge}.}

\item{start_date}{Character. Optional start date with format
YYYY-MM-DD. Default is 1900-01-01.}

\item{end_date}{Character. End date with format YYYY-MM-DD.
Default is the current date.}

\item{sites}{Logical. If TRUE, returns a list of measurement
sites.}

\item{...}{Additional arguments. None implemented.}
}
\value{
data frame of discharge time-series
}
\description{
Retrieve Australian gauge data
}
\examples{
\dontrun{
sites <- australia(sites = TRUE)
df <- australia(sites$site[1], "stage")
plot(df$Date, df$H, type='l')
}
}
