% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ResIN.R
\name{as.tidygraph.ResIN}
\alias{as.tidygraph.ResIN}
\title{Coerce a ResIN object to a tidygraph graph}
\usage{
\method{as.tidygraph}{ResIN}(x, directed = FALSE, ...)
}
\arguments{
\item{x}{A \code{ResIN} object.}

\item{directed}{Logical; should the resulting graph be treated as directed?
Defaults to \code{FALSE}.}

\item{...}{Ignored.}
}
\value{
A \code{tidygraph::tbl_graph} object. Node data include (when present)
  all columns from \code{x$ResIN_nodeframe}; edge data include (when present)
  all columns from \code{x$ResIN_edgelist}, plus \code{from_name}/\code{to_name}
  preserving original endpoint labels.
}
\description{
Converts a \code{ResIN} object to a \code{tidygraph::tbl_graph} object while
preserving as much node- and edge-level information as possible from
\code{x$ResIN_nodeframe} and \code{x$ResIN_edgelist}.

Because \code{tidygraph} stores edge endpoints as integer node indices, the
original edge endpoint labels are preserved in additional edge columns
\code{from_name} and \code{to_name}.

If \code{ResIN_nodeframe} or \code{ResIN_edgelist} are unavailable, the method
falls back to a simpler conversion via \code{as.igraph()} followed by
\code{tidygraph::as_tbl_graph()}, which may not preserve all metadata.
}
\examples{
## Load toy data and estimate ResIN
data(lik_data)
res <- ResIN(lik_data, network_stats = TRUE, detect_clusters = TRUE,
             plot_ggplot = FALSE)

## Convert to tidygraph
tg <- as.tidygraph(res)

class(tg)

}
