% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ResIN.R
\name{as.networkx.ResIN}
\alias{as.networkx.ResIN}
\title{Export a ResIN object to NetworkX (Python) tables}
\usage{
\method{as.networkx}{ResIN}(
  x,
  file = "ResIN_networkx.csv",
  edges_only = TRUE,
  dont_save_csv = FALSE,
  weight_col = "weight",
  ...
)
}
\arguments{
\item{x}{A \code{ResIN} object.}

\item{file}{Output file name (legacy style). If \code{edges_only = TRUE},
the edge table is written to \code{file}. If \code{edges_only = FALSE},
\code{file} is treated as a prefix and \code{"_edges.csv"} /
\code{"_nodes.csv"} are appended (with any trailing \code{.csv} removed).}

\item{edges_only}{Logical; if TRUE (default), only write/return edge table.}

\item{dont_save_csv}{Logical; if FALSE (default), write CSV output. If TRUE,
no files are written and the resulting table(s) are returned visibly.}

\item{weight_col}{Preferred edge-weight column name. Defaults to \code{"weight"}.}

\item{...}{Ignored.}
}
\value{
If \code{edges_only = TRUE}, an edge table \code{data.frame}.
  Otherwise a list with elements \code{edges} and \code{nodes}.
}
\description{
Produces NetworkX-ready edge (and optionally node) tables
from a \code{ResIN} object for further manipulation in Python.
By default, this method writes CSV files that can be imported into Python
via \pkg{pandas} and \pkg{networkx}. Node and edge metadata are preserved as
table columns.
}
\examples{
\dontrun{
data(lik_data)
res <- ResIN(lik_data, generate_ggplot = FALSE, plot_ggplot = FALSE)

# Return tables only (no files written)
nx_tbls <- as.networkx(res, dont_save_csv = TRUE, edges_only = FALSE)

# Default behavior writes CSV files
# as.networkx(res, file = "ResIN_networkx.csv", edges_only = FALSE)
}

}
