% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ResIN.R
\name{as.igraph.ResIN}
\alias{as.igraph.ResIN}
\title{Coerce a ResIN object to an igraph graph}
\usage{
\method{as.igraph}{ResIN}(x, mode = "undirected", weighted = TRUE, diag = FALSE, ...)
}
\arguments{
\item{x}{A \code{ResIN} object.}

\item{mode, weighted, diag}{Passed to \code{igraph::graph_from_adjacency_matrix()}.}

\item{...}{Additional arguments passed to \code{igraph::graph_from_adjacency_matrix()}.}
}
\value{
An \code{igraph} object.
}
\description{
Converts a \code{ResIN} object to an \code{igraph} graph using the adjacency
matrix stored in \code{x$aux_objects$adj_matrix}.
}
\examples{
## Load the 12-item simulated Likert-type ResIN toy dataset
data(lik_data)

## Run the function:

igraph_output <-  as.igraph(ResIN(lik_data, plot_ggplot = FALSE))

class(igraph_output)

## Plot and/or investigate as you wish:
\donttest{
igraph::plot.igraph(igraph_output)
}

}
