% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{custom_modulelist}
\alias{custom_modulelist}
\alias{transform_modulelist}
\title{Build a custom modulelist}
\usage{
custom_modulelist(pathway2ko, pathway2desc = NULL, verbose = TRUE)

transform_modulelist(mymodulelist, mode = 1)
}
\arguments{
\item{pathway2ko}{user input annotation of Pathway to KO mapping, a data.frame of 2 column with pathway and ko.}

\item{pathway2desc}{user input of Pathway TO Description mapping, a data.frame of 2 column with pathway and description.}

\item{verbose}{verbose}

\item{mymodulelist}{mymodulelist}

\item{mode}{1~2}
}
\value{
a custom modulelist

modulelist
}
\description{
Build a custom modulelist

Transform a modulelist to a list
}
\examples{
mydat <- data.frame(pathway = paste0("PATHWAY", rep(seq_len(2), each = 5)), ko = paste0("K", 1:10))
mymodulelist <- custom_modulelist(mydat)
print(mymodulelist)
transform_modulelist(mymodulelist)
}
\seealso{
Other modulelist: 
\code{\link{custom_modulelist_from_org}()},
\code{\link{get_features}()}

Other modulelist: 
\code{\link{custom_modulelist_from_org}()},
\code{\link{get_features}()}
}
\concept{modulelist}
