% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dWP.R
\name{dWP}
\alias{dWP}
\alias{pWP}
\alias{qWP}
\alias{rWP}
\alias{hWP}
\title{The Weibull Poisson distribution}
\usage{
dWP(x, mu, sigma, nu, log = FALSE)

pWP(q, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

qWP(p, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

rWP(n, mu, sigma, nu)

hWP(x, mu, sigma, nu)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{nu}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dWP} gives the density, \code{pWP} gives the distribution 
function, \code{qWP} gives the quantile function, \code{rWP}
generates random deviates and \code{hWP} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the Weibull Poisson distribution
with parameters \code{mu}, \code{sigma} and \code{nu}.
}
\details{
The Weibull Poisson distribution with parameters \code{mu}, 
\code{sigma} and \code{nu} has density given by

\eqn{f(x) = \frac{\mu \sigma \nu e^{-\nu}} {1-e^{-\nu}} x^{\mu-1} \exp({-\sigma x^{\mu}+\nu \exp({-\sigma} x^{\mu}) }),}

for \eqn{x > 0}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dWP(x, mu=1.5, sigma=0.5, nu=10), from=0.0001, to=2,
      col="red", las=1, ylab="f(x)")

## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pWP(x, mu=1.5, sigma=0.5, nu=10),
      from=0.0001, to=2, col="red", las=1, ylab="F(x)")
curve(pWP(x, mu=1.5, sigma=0.5, nu=10, lower.tail=FALSE),
      from=0.0001, to=2, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qWP(p, mu=1.5, sigma=0.5, nu=10), y=p, xlab="Quantile",
     las=1, ylab="Probability")
curve(pWP(x, mu=1.5, sigma=0.5, nu=10),
      from=0, add=TRUE, col="red")

## The random function
hist(rWP(n=10000, mu=1.5, sigma=0.5, nu=10), freq=FALSE,
     xlab="x", ylim=c(0, 2.2), las=1, main="")
curve(dWP(x, mu=1.5, sigma=0.5, nu=10),
      from=0.001, to=4, add=TRUE, col="red")

## The Hazard function
curve(hWP(x, mu=1.5, sigma=0.5, nu=10), from=0.001, to=5,
      col="red", ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
Lu, Wanbo, and Daimin Shi. "A new compounding life distribution: 
the Weibull–Poisson distribution." Journal of applied 
statistics 39.1 (2012): 21-38.
}
\seealso{
\link{WP}
}
\author{
Amylkar Urrea Montoya, \email{amylkar.urrea@udea.edu.co}
}
