% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dBS3.R
\name{dBS3}
\alias{dBS3}
\alias{pBS3}
\alias{qBS3}
\alias{rBS3}
\alias{hBS3}
\title{The Birnbaum-Saunders distribution - Bourguignon & Gallardo (2022)}
\usage{
dBS3(x, mu = 1, sigma = 0.5, log = FALSE)

pBS3(q, mu = 1, sigma = 0.5, lower.tail = TRUE, log.p = FALSE)

qBS3(p, mu = 1, sigma = 0.5, lower.tail = TRUE, log.p = FALSE)

rBS3(n, mu = 1, sigma = 0.5)

hBS3(x, mu, sigma)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dBS3} gives the density, \code{pBS3} gives the distribution 
function, \code{qBS3} gives the quantile function, \code{rBS3}
generates random deviates and \code{hBS3} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the 
Birnbaum-Saunders distribution with
parameters \code{mu} and \code{sigma}.
}
\details{
The Birnbaum-Saunders with parameters \code{mu} and \code{sigma}
has density given by

\eqn{f(x) = \frac{\exp(\sigma/2)\sqrt{\sigma+1}}{4\sqrt{\pi\mu}x^{3/2}} \left[ x + \frac{\mu\sigma}{\sigma+1} \right] \exp\left( \frac{-\sigma}{4} \left(\frac{x(\sigma+1)}{\mu\sigma}+\frac{\mu\sigma}{x(\sigma+1)} \right) \right) }

for \eqn{x>0}, \eqn{\mu>0} and \eqn{\sigma>0}. In this 
parameterization 
\eqn{E(X)=\mu} and 
\eqn{Var(X)=(\mu\sigma)^2(1+5\sigma^2/4)}. The functions 
proposed here corresponds to the 
parameterization proposed by 
Santos-Neto et al. (2014).
}
\examples{
# Example 1
# Plotting the mass function for different parameter values
curve(dBS3(x, mu=2, sigma=0.2), 
      from=0.001, to=10,
      ylim=c(0, 0.4), 
      col="royalblue1", lwd=2, 
      main="Density function",
      xlab="x", ylab="f(x)")
curve(dBS3(x, mu=2, sigma=0.4),
      col="tomato", 
      lwd=2,
      add=TRUE)
legend("topright", legend=c("mu=2, sigma=0.2", 
                            "mu=2, sigma=0.4"),
       col=c("royalblue1", "tomato"), lwd=2, cex=0.6)

# Example 2
# Checking if the cumulative curves converge to 1
curve(pBS3(x, mu=2, sigma=0.2), 
      from=0.00001, to=10,
      ylim=c(0, 1), 
      col="royalblue1", lwd=2, 
      main="Cumulative Distribution Function",
      xlab="x", ylab="f(x)")
curve(pBS3(x, mu=2, sigma=0.4),
      col="tomato", 
      lwd=2,
      add=TRUE)
legend("bottomright", legend=c("mu=2, sigma=0.2", 
                               "mu=2, sigma=0.4"),
       col=c("royalblue1", "tomato", "seagreen"), lwd=2, cex=0.5)

# Example 3
# The quantile function
p <- seq(from=0, to=0.999, length.out=100)
plot(x=qBS3(p, mu=2, sigma=0.2), y=p, xlab="Quantile",
     las=1, ylab="Probability", main="Quantile function ")
curve(pBS3(x, mu=2, sigma=0.2), 
      from=0, add=TRUE, col="tomato", lwd=2.5)

# Example 4
# The random function
x <- rBS3(n=10000, mu=2, sigma=0.2)
hist(x, freq=FALSE)
curve(dBS3(x, mu=2, sigma=0.2), from=0, to=10, 
      add=TRUE, col="tomato", lwd=2)

# Example 5
# The Hazard function
curve(hBS3(x, mu=2, sigma=0.2), from=0.001, to=4,
      col="tomato", ylab="Hazard function", las=1)

}
\references{
Bourguignon, M., & Gallardo, D. I. (2022). A new look at the 
Birnbaum–Saunders regression model. Applied Stochastic Models in 
Business and Industry, 38(6), 935-951.
}
\seealso{
\link{BS3}.
}
