% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rddocs.R
\name{rddocs}
\alias{rddocs}
\title{Open Dataset Documentation}
\usage{
rddocs(dataset, package = NULL)
}
\arguments{
\item{dataset}{String. Name of the dataset to download from the Rdatasets archive. Use \code{rdsearch()} to search available datasets.}

\item{package}{String. Package name that originally published the data. If NULL, the function will attempt to automatically detect the package by searching for an exact match in the Rdatasets index.}
}
\value{
Invisibly returns \code{NULL}. The function's primary purpose is to open the dataset documentation in a viewer window.
}
\description{
Opens the documentation for a dataset from Rdatasets as an HTML page using \code{getOption("viewer")} or the Rstudio viewer.
}
\details{
The function attempts to open the documentation in the following order:
\enumerate{
\item RStudio's built-in viewer (if \code{rstudioapi} is available)
\item The viewer specified in \code{getOption("viewer")}
\item The default browser specified in \code{getOption("browser")}
}

To control which viewer is used, you can set the following options:
\itemize{
\item \code{options(viewer = function(url) { ... })} - Set a custom viewer function
\item \code{options(browser = "firefox")} - Set the default browser (used as fallback)
}

If no viewer is available, the function will stop with an error message.
}
\section{Global Options}{

The following global options control package behavior:
\itemize{
\item \code{Rdatasets_cache}: Logical
\itemize{
\item Whether to cache downloaded data and index for faster subsequent access. Default: \code{TRUE}. Please keep this option TRUE as it makes repeated access faster and avoids overloading the Rdatasets server. Only set to FALSE if local memory is severely limited.
\item Ex: `options(Rdatasets_cache = TRUE)``
}
\item \code{Rdatasets_class}: String
\itemize{
\item Output class of the returned data. One of "data.frame" (default), "tibble", or "data.table". Default: \code{"data.frame"}. Requires the respective packages to be installed for "tibble" or "data.table" formats.
\item Ex: \code{options(Rdatasets_class = "tibble")}
}
\item \code{Rdataset_path}: String.
\itemize{
\item Base URL for the Rdatasets archive. Default: \code{"https://vincentarelbundock.github.io/Rdatasets/"}. Advanced users can set this to use a different mirror or local copy.
\item Ex: \code{options(Rdataset_path = "https://vincentarelbundock.github.io/Rdatasets/")}
}
}
}

\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
rddocs(dataset = "Titanic", package ="Stat2Data")
rddocs("iris", "datasets")
\dontshow{\}) # examplesIf}
}
