% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppTskit.R
\name{ts_py_to_r}
\alias{ts_py_to_r}
\title{Transfer a tree sequence from reticulate Python to R}
\usage{
ts_py_to_r(ts, cleanup = TRUE)
}
\arguments{
\item{ts}{tree sequence in reticulate Python.}

\item{cleanup}{logical; delete the temporary file at the end of the function?}
}
\value{
A \code{\link{TreeSequence}} object.
}
\description{
This function saves a tree sequence from reticulate Python to disk
  and reads it into R for use with \code{RcppTskit}.
}
\examples{
\dontrun{
  ts_file <- system.file("examples/test.trees", package = "RcppTskit")

  # Use the tskit Python API to work with a tree sequence (via reticulate)
  tskit <- get_tskit_py()
  if (check_tskit_py(tskit)) {
    ts_py <- tskit$load(ts_file)
    is(ts_py)
    ts_py$num_individuals # 8
    ts2_py <- ts_py$simplify(samples = c(0L, 1L, 2L, 3L))
    ts_py$num_individuals # 8
    ts2_py$num_individuals # 2
    ts2_py$num_nodes # 8
    ts2_py$tables$nodes$time # 0.0 ... 5.0093910

    # Transfer the tree sequence to R and use RcppTskit
    ts2_r <- ts_py_to_r(ts2_py)
    is(ts2_r)
    ts2_r$num_individuals() # 2
  }
}
}
\seealso{
\code{\link[=TreeSequence]{TreeSequence$r_to_py}}
  \code{\link{ts_load}}, and \code{\link[=TreeSequence]{TreeSequence$dump}}.
}
