% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dense_matrix_kernels.R
\name{MatvecMicrobenchmark}
\alias{MatvecMicrobenchmark}
\title{Conducts a single performance trial with the matrix-vector multiplication
dense matrix kernel}
\usage{
MatvecMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{DenseMatrixMicrobenchmark}} specifying various parameters
for microbenchmarking the dense matrix kernel}

\item{kernelParameters}{a list of matrices or vectors to be used as input to
the dense matrix kernel}
}
\description{
\code{MatvecMicrobenchmark} conducts a single performance trial of the
matrix-vector multiplication dense matrix kernel for the matrix given in the
\code{kernelParameters} parameter.  The function times the single function
call \code{kernelParameters$A \%*\% kernelParameters$b}.
}
\examples{
\dontrun{
# Allocate input to the matrix-vector multiplication microbenchmark for the
# first matrix size to be tested
microbenchmarks <- GetDenseMatrixDefaultMicrobenchmarks()
kernelParameters <- MatvecAllocator(microbenchmarks[["matvec"]], 1)
# Execute the microbenchmark
timings <- MatvecMicrobenchmark(microbenchmarks[["matvec"]], kernelParameters)
}

}
