% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_matrix_benchmark.R
\name{GetSparseQrDefaultMicrobenchmarks}
\alias{GetSparseQrDefaultMicrobenchmarks}
\title{Initializes the list of default sparse QR factorization microbenchmarks}
\usage{
GetSparseQrDefaultMicrobenchmarks()
}
\value{
a list of \code{SparseMatrixMicrobenchmark} objects defining the
  microbenchmarks to be executed.  The microbenchmarks appear in the order
  listed in the function description and are assigned the names enumerated
  in the description.
}
\description{
\code{GetSparseQrDefaultMicrobenchmarks} defines the default sparse QR
factorization microbenchmarks to be executed by the
\code{\link{RunSparseMatrixBenchmark}} function.  The current sparse QR
factorization microbenchmarks cover a variety of matrices of different
dimensions and number of non-zero values.  They are as follows:
\enumerate{
  \item Maragal_6 -- rank deficient least squares matrix of 537694 nonzeros
  \item landmark -- least squares matrix of 1146848
}
See the documentation for the
\code{\link{SparseMatrixMicrobenchmark}} class for more details.
}
\seealso{
\code{\link{SparseMatrixMicrobenchmark}}

Other sparse matrix default microbenchmarks: \code{\link{GetSparseCholeskyDefaultMicrobenchmarks}},
  \code{\link{GetSparseCholeskyExampleMicrobenchmarks}},
  \code{\link{GetSparseLuDefaultMicrobenchmarks}},
  \code{\link{GetSparseMatrixVectorDefaultMicrobenchmarks}},
  \code{\link{GetSparseMatrixVectorExampleMicrobenchmarks}}
}
