% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_matrix_benchmark.R
\name{GetSparseMatrixVectorDefaultMicrobenchmarks}
\alias{GetSparseMatrixVectorDefaultMicrobenchmarks}
\title{Initializes the list of default sparse matrix-vector microbenchmarks}
\usage{
GetSparseMatrixVectorDefaultMicrobenchmarks()
}
\value{
a list of \code{SparseMatrixMicrobenchmark} objects defining the
  microbenchmarks to be executed.  The microbenchmarks appear in the order
  listed in the function description and are assigned the names enumerate
  in the description.
}
\description{
\code{GetSparseMatrixVectorDefaultMicrobenchmarks} defines the default sparse
matrix-vector microbenchmarks to be executed by the
\code{\link{RunSparseMatrixBenchmark}} function.  The current sparse
matrix-vector microbenchmarks cover a variety of matrices of different
dimensions and number of non-zero values.  They are as follows:
\enumerate{
  \item matvec_laplacian7pt_100 -- 100x100x100 7-point Laplacian operator
  \item matvec_laplacian7pt_200 -- 200x200x200 7-point Laplacian operator
  \item matvec_ca2010 -- DIMACS10/ca2010 710145x710145 undirected graph
     matrix
}
See the documentation for the
\code{\link{SparseMatrixMicrobenchmark}} class for more details.
}
\seealso{
\code{\link{SparseMatrixMicrobenchmark}}

Other sparse matrix default microbenchmarks: \code{\link{GetSparseCholeskyDefaultMicrobenchmarks}},
  \code{\link{GetSparseCholeskyExampleMicrobenchmarks}},
  \code{\link{GetSparseLuDefaultMicrobenchmarks}},
  \code{\link{GetSparseMatrixVectorExampleMicrobenchmarks}},
  \code{\link{GetSparseQrDefaultMicrobenchmarks}}
}
