% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.epplabOutlier.R
\docType{methods}
\name{print.epplabOutlier}
\alias{print.epplabOutlier}
\alias{print,epplabOutlier-method}
\title{Print an epplabOutlier Object}
\usage{
\method{print}{epplabOutlier}(x, ...)
}
\arguments{
\item{x}{Object of class \code{epplabOutlier}.}

\item{...}{Additional parameters}
}
\description{
Prints an \code{epplabOutlier} object.
}
\details{
The \code{print} function displays only the \code{outlier} matrix from the
\code{epplabOutlier} object.
}
\examples{

# creating data with 3 outliers
n <-300 
p <- 10
X <- matrix(rnorm(n*p),ncol=p)
X[1,1] <- 9
X[2,4] <- 7 
X[3,6] <- 8
# giving the data rownames, obs.1, obs.2 and obs.3 are the outliers.
rownames(X) <- paste("obs",1:n,sep=".")

PP<-EPPlab(X,PPalg="PSO",PPindex="KurtosisMax",n.simu=20, maxiter=20)
OUT<-EPPlabOutlier(PP, k = 3, location = median, scale = mad)
OUT

}
\author{
Klaus Nordhausen
}
\keyword{methods}
\keyword{print}
