% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{target.data}
\alias{target.data}
\title{A data set of simulated RCT data, where outcome is continuous variable, treatment is a binary variable.}
\format{
## `target.data`
A data frame with 5000 rows and 8 variables:
\describe{
\item{x1}{binary variable, x1 ~ rbinom(5000,1,0.7)}
\item{x2}{binary variable, x2 ~ rbinom(5000,1,0.9)}
\item{x3}{binary variable, x3 ~ rbinom(5000,1,0.2)}
\item{x4}{binary variable, x4 ~ rbinom(5000,1,0.3)}
\item{x5}{binary variable, x5 ~ rbinom(5000,1,0.2)}
\item{x6}{binary variable, x6 ~ rbinom(5000,1,0.3)}
\item{z}{binary variable indicating treatment and control, z ~ rbinom(5000,1,0.5)}
\item{y}{continuous variable indicating outcome, y ~ x1 + 6*x2+x6+2*z + rnorm(5000,0,1)}
}
}
\usage{
target.data
}
\description{
A data set of simulated RCT data, where outcome is continuous variable, treatment is a binary variable.
}
\keyword{datasets}
