% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{estimate_factor_group}
\alias{estimate_factor_group}
\title{Estimates group factors Fg.}
\usage{
estimate_factor_group(
  Y,
  X,
  beta_est,
  g,
  lambda,
  comfactor,
  factor_group,
  S,
  k,
  kg,
  robust,
  method_estimate_beta = "individual",
  method_estimate_factors = "macro",
  initialise = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{beta_est}{estimated values of beta}

\item{g}{Vector with group membership for all individuals}

\item{lambda}{loadings of the estimated common factors}

\item{comfactor}{estimated common factors}

\item{factor_group}{estimated group specific factors}

\item{S}{number of estimated groups}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{method_estimate_factors}{defines method of robust estimaton of the factors: "macro", "pertmm" or "cz"}

\item{initialise}{indicator of being in the initialisation phase}

\item{verbose}{when TRUE, it prints messages}
}
\value{
Returns a list with an element for each estimated group. Each element of the list is a matrix with the group specific factors as rows.
}
\description{
Estimates group factors Fg.
}
\examples{
#example with data generated with DGP 2
data <- create_data_dgp2(30, 10)
Y <- data[[1]]
X <- data[[2]]
g <- data[[3]] #true group membership
set.seed(1)
beta_est <- matrix(rnorm(4 * nrow(Y)), nrow = 4)
factor_group <- data[[5]] #true values of group specific factors
comfactor <- matrix(0, nrow = 1, ncol = ncol(Y))
lambda <- matrix(0, nrow = 1, ncol = nrow(Y))
estimate_factor_group(Y, X, beta_est, g, lambda, comfactor, factor_group,
3, 0, c(3, 3, 3), TRUE)
}
