% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{internal}
\alias{internal}
\alias{par_position}
\alias{par_name}
\alias{tails}
\alias{maf_filt}
\alias{XValidate_nonInd}
\alias{XValidate_Ind}
\alias{calc_marker_effects}
\title{Internal functions}
\usage{
par_position(crossing.table, par.entries)

par_name(crossing.mat, par.entries)

tails(GEBVs, tail.p)

maf_filt(G)

XValidate_nonInd(
  y.CV = NULL,
  G.CV = NULL,
  models.CV = NULL,
  frac.train.CV = NULL,
  nCV.iter.CV = NULL,
  burnIn.CV = NULL,
  nIter.CV = NULL
)

XValidate_Ind(
  y.CV = NULL,
  G.CV = NULL,
  models.CV = NULL,
  nFold.CV = NULL,
  nFold.CV.reps = NULL,
  burnIn.CV = NULL,
  nIter.CV = NULL
)

calc_marker_effects(
  M,
  y.df,
  models = c("rrBLUP", "BayesA", "BayesB", "BayesC", "BL", "BRR"),
  nIter,
  burnIn
)
}
\arguments{
\item{crossing.table}{The crossing table.}

\item{par.entries}{The parent entries.}

\item{crossing.mat}{The crossing matrix.}

\item{GEBVs}{The genomic estimated breeding values.}

\item{tail.p}{The proportion from the population to select.}

\item{G}{The marker genotypes}

\item{y.CV}{The phenotypes for cross-validation.}

\item{G.CV}{The marker genotypes for cross-validation.}

\item{models.CV}{The models for cross-validation.}

\item{frac.train.CV}{The fraction of data to use as training data in cross-validation.}

\item{nCV.iter.CV}{The number of iterations of cross-validation.}

\item{burnIn.CV}{The burn-in number for cross-validation.}

\item{nIter.CV}{The number of iterations for Bayesian models in cross-validation.}

\item{nFold.CV}{The number of folds in k-fold cross-validation.}

\item{nFold.CV.reps}{The number of replications of k-fold cross-validation.}

\item{M}{The marker matrix.}

\item{y.df}{The phenotype data.}

\item{models}{The models to use.}

\item{nIter}{The number of iterations.}

\item{burnIn}{The burn-in rate.}
}
\description{
Internal functions generally not to be called by the user.
}
