% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.cont_phase_type}
\alias{print.cont_phase_type}
\alias{print.disc_phase_type}
\alias{print.mult_cont_phase_type}
\alias{print.mult_disc_phase_type}
\title{Print method for phase-type objects}
\usage{
\method{print}{cont_phase_type}(x, ...)

\method{print}{disc_phase_type}(x, ...)

\method{print}{mult_cont_phase_type}(x, ...)

\method{print}{mult_disc_phase_type}(x, ...)
}
\arguments{
\item{x}{phase-type object}

\item{...}{other arguments not used by this method}
}
\value{
Prints the phase-type object as a list.
}
\description{
Print method for \code{cont_phase_type}, \code{disc_phase_type},
\code{mult_cont_phase_type} and \code{mult_disc_phase_type} classes.
}
\examples{
subintensity_matrix <- matrix(c(-1.5, 1.5, 0,
                                 0,  -1,   1,
                                 0,   0,  -0.5),
                              ncol = 3,
                              byrow = TRUE)
ph1 <- PH(subintensity_matrix)

print(ph1)

}
