% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{birds_peru_tbl_df}
\alias{birds_peru_tbl_df}
\title{Bird species recorded in Peru}
\format{
A tibble with 1,914 observations and 6 variables:
\describe{
  \item{order_name}{Taxonomic order of the bird species (character)}
  \item{family_name}{Taxonomic family of the bird species (character)}
  \item{scientific_name}{Scientific name of the bird species (character)}
  \item{english_name}{Common name in English (character)}
  \item{spanish_name}{Common name in Spanish (character)}
  \item{status}{Conservation or taxonomic status of the species (character)}
}
}
\source{
Data taken from the \pkg{avesperu} package version 0.0.6
}
\usage{
data(birds_peru_tbl_df)
}
\description{
This dataset, birds_peru_tbl_df, is a tibble containing an updated list of bird species
recorded in Peru, based on the most recent taxonomic revisions by the South American
Checklist Committee (SACC). It provides comprehensive information about avian biodiversity
in Peru, including taxonomic classification, common names in English and Spanish, and
conservation status for each species.
}
\details{
The dataset name has been kept as 'birds_peru_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PeruAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
