% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{andean_migrants_health_df}
\alias{andean_migrants_health_df}
\title{Peruvian Andean migrants health study}
\format{
A data frame with 39 observations and 5 variables:
\describe{
  \item{age}{Age of the subject (integer)}
  \item{years}{Years since migration to lower altitude (integer)}
  \item{weight}{Weight of the subject (numeric)}
  \item{height}{Height of the subject (integer)}
  \item{BP}{Blood pressure measurement (integer)}
}
}
\source{
Data taken from the \pkg{s20x} package version 3.1-40
}
\usage{
data(andean_migrants_health_df)
}
\description{
This dataset, andean_migrants_health_df, is a data frame containing health data from
a random sample of Peruvians born in the Andes mountains, but who have since migrated
to lower altitudes. The sample was collected to assess the long-term effects of altitude
on blood pressure and other health indicators, providing valuable insights into the
physiological adaptations of high-altitude populations.
}
\details{
The dataset name has been kept as 'andean_migrants_health_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PeruAPIs package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame object. The original content has not been modified
in any way.
}
