% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographicsQuery.R
\name{addFutureObservationQuery}
\alias{addFutureObservationQuery}
\title{Query to add the number of days till the end of the observation period at a
certain date}
\usage{
addFutureObservationQuery(
  x,
  indexDate = "cohort_start_date",
  futureObservationName = "future_observation",
  futureObservationType = "days"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the date to compute the
demographics characteristics.}

\item{futureObservationName}{Future observation variable name.}

\item{futureObservationType}{Whether to return a "date" or the number of
"days".}
}
\value{
cohort table with added column containing future observation of the
individuals.
}
\description{
Same as \code{addFutureObservation()}, except query is not computed to a table.
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort1 |>
  addFutureObservationQuery()

}
}
