\name{PartialTL-package}
\alias{PartialTL-package}
\alias{PartialTL}
\docType{package}
\title{
  Partial Transfer Learning for Causal Estimation and Source Detection
}
\description{
  Implements partial transfer learning (PTL) and heterogeneous partial transfer
  learning (HPTL) for causal effect estimation using source and target data.
  Uses double machine learning for nuisance estimation and cross-fitting.
  Provides bootstrap-based source detection to identify which sources are
  transferable to the target. Includes data generating processes and nuisance
  functions for simulation.
}
\details{
  Main functions:
  \itemize{
    \item \code{\link{fit_PTL}}: PTL causal estimate (single source).
    \item \code{\link{fit_HPTL}}: Heterogeneous PTL with multiple sources and
      covariate modules.
    \item \code{\link{boot_detection}}: Bootstrap-based source detection.
    \item \code{\link{run_bootstrap_E_hat}}: Bootstrap for nuisance function
      estimation.
    \item \code{\link{DGP}}: Data generating process for simulations.
    \item \code{\link{RMSE}}: Root mean squared error for evaluation.
    \item \code{\link{f_0}}, \code{\link{g_0}}, \code{\link{f_k}}, \code{\link{g_k}}:
      Nuisance functions for target and source models.
  }
  Run \code{demo(package = "PartialTL")} for demo scripts.
}
\author{
  Author \email{author@example.com}
}
\references{
  (Add references to the partial transfer learning and DML literature.)
}
\keyword{package}
