% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{EstPSTR}
\alias{EstPSTR}
\title{Estimate a PSTR model by nonlinear least squares}
\usage{
EstPSTR(
  use,
  im = 1,
  iq = NULL,
  par = NULL,
  useDelta = FALSE,
  vLower = 2,
  vUpper = 2,
  method = "L-BFGS-B"
)
}
\arguments{
\item{use}{An object of class \code{"PSTR"} created by \code{\link{NewPSTR}}.}

\item{im}{Integer. Number of switches \eqn{m} in the transition function. Default is \code{1}.}

\item{iq}{Either an integer index (column number in the transition-variable matrix) or a
character string (transition-variable name) specifying which transition variable to use.
If \code{NULL}, a linear fixed-effects panel regression is estimated.}

\item{par}{Numeric vector of length \code{im + 1} giving initial values for the nonlinear
parameters. The expected order is \code{c(delta, c_1, ..., c_m)} if \code{useDelta = TRUE},
or \code{c(gamma, c_1, ..., c_m)} if \code{useDelta = FALSE}. If \code{NULL}, defaults are
constructed automatically and \code{useDelta} is ignored.}

\item{useDelta}{Logical. If \code{TRUE}, the first element of \code{par} is interpreted as
\eqn{\delta}. If \code{FALSE}, it is interpreted as \eqn{\gamma} and internally converted
to \eqn{\delta = \log(\gamma)} before optimisation.}

\item{vLower}{Numeric scalar or vector. Lower offsets defining the lower bounds in the optimiser.
Bounds are applied to the internal parameter vector used in optimisation (with the first
element being \eqn{\delta}).}

\item{vUpper}{Numeric scalar or vector. Upper offsets defining the upper bounds in the optimiser.
Bounds are applied to the internal parameter vector used in optimisation (with the first
element being \eqn{\delta}).}

\item{method}{Character. Optimisation method passed to \code{\link[stats:optim]{stats::optim}}.
Default is \code{"L-BFGS-B"} (bounded optimisation).}
}
\value{
Invisibly returns \code{use} with estimation results added. In particular, for a
  nonlinear PSTR model (\code{iq} not \code{NULL}), the object contains (among others):
\describe{
  \item{\code{delta}}{Estimate of \eqn{\delta}.}
  \item{\code{gamma}}{Estimate of \eqn{\gamma = \exp(\delta)}.}
  \item{\code{c}}{Estimates of \eqn{c_1,\ldots,c_m}.}
  \item{\code{vg}}{Estimated transition-function values \eqn{g_{it}}.}
  \item{\code{beta}}{Estimated coefficients (named as \code{var_0} for linear-part coefficients and \code{var_1} for nonlinear-part coefficients).}
  \item{\code{vU}}{Residuals.}
  \item{\code{vM}}{Estimated individual effects.}
  \item{\code{s2}}{Estimated residual variance.}
  \item{\code{cov}}{Cluster-robust and heteroskedasticity-consistent covariance matrix of all estimates.}
  \item{\code{se}}{Standard errors corresponding to \code{est}.}
  \item{\code{est}}{Vector of all estimates (coefficients followed by nonlinear parameters).}
  \item{\code{mbeta}}{Estimates of coefficients in the second extreme regime (when available).}
  \item{\code{mse}}{Standard errors for \code{mbeta} (when available).}
}
For a linear fixed-effects model (\code{iq = NULL}), the object contains \code{beta}, \code{vU},
\code{vM}, \code{s2}, \code{cov}, \code{se}, and \code{est}.
}
\description{
\code{EstPSTR} estimates either a nonlinear PSTR model (when \code{iq} is provided) or a
linear fixed-effects panel regression (when \code{iq = NULL}).
}
\details{
Two equivalent interfaces are available:
\enumerate{
  \item Wrapper function: \code{EstPSTR(use = obj, ...)}.
  \item R6 method: \code{obj$EstPSTR(...)}.
}
The wrapper calls the corresponding R6 method and returns \code{use} invisibly.

The transition function is logistic and depends on a transition variable \eqn{q_{it}} and
nonlinear parameters \eqn{\gamma > 0} and switching locations \eqn{c_1 < \cdots < c_m}:
\deqn{g(q_{it}; \gamma, c_1,\ldots,c_m) = \left(1 + \exp\left[-\gamma \prod_{j=1}^{m}(q_{it}-c_j)\right]\right)^{-1}.}
The smoothness parameter is internally reparametrised as \eqn{\gamma = \exp(\delta)}, where
\eqn{\delta \in \mathbb{R}}. The optimisation is always carried out in \eqn{\delta} and \eqn{c}.

If \code{par = NULL}, the function constructs default initial values from quantiles of the
selected transition variable and treats the first element as \eqn{\delta}.
}
\examples{
\donttest{
pstr <- NewPSTR(Hansen99, dep = "inva", indep = 4:20,
               indep_k = c("vala","debta","cfa","sales"),
               tvars = c("vala"), iT = 14)

# 1) Linear fixed-effects model
pstr <- EstPSTR(use = pstr)
print(pstr, mode = "estimates", digits = 6)

# 2) Nonlinear PSTR model
pstr <- EstPSTR(use = pstr, im = 1, iq = 1, useDelta = TRUE,
               par = c(.63, 0), vLower = 4, vUpper = 4)
print(pstr, mode = "estimates", digits = 6)

# R6 method interface (equivalent)
pstr$EstPSTR(im = 1, iq = 1, useDelta = TRUE, par = c(.63, 0), method = "CG")
}

}
\seealso{
\code{\link{NewPSTR}}, \code{\link{LinTest}}, \code{\link{WCB_LinTest}},
  \code{\link{EvalTest}}, \code{\link[stats:optim]{stats::optim}}.
}
