\name{compute_cmtg}
\alias{compute_cmtg}
\title{Compute Complementary Mean Time to Germination (cMTG)}
\description{
Calculates cMTG as the complement of the normalized time to 50\%
germination, bounded in \code{[0, 1]}.
}
\usage{
compute_cmtg(germination_counts, timepoints, total_seeds)
}
\arguments{
  \item{germination_counts}{Integer vector of cumulative germination counts
    at each timepoint.}
  \item{timepoints}{Numeric vector of observation times.}
  \item{total_seeds}{Integer. Total number of seeds in the replicate.}
}
\value{
Numeric value in \code{[0, 1]}. Higher values indicate faster
germination.
}
\details{
\deqn{cMTG = 1 - t_{50} / t_{max}}
where \eqn{t_{50}} is the interpolated time at which 50\% of the final
germination count is reached.
}
\examples{
compute_cmtg(c(20, 23, 25), timepoints = c(3, 5, 7), total_seeds = 25)
compute_cmtg(c(2, 8, 20), timepoints = c(3, 5, 7), total_seeds = 25)
}
\seealso{\code{\link{compute_psri_sm}}}
