% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDN.R
\name{datecut}
\alias{datecut}
\title{Generating Optimal cuts for the Data}
\usage{
datecut(x, surdays, event)
}
\arguments{
\item{x}{comorbidity data matrix with column correspond to ICD9 codes and row correspond to each patient}

\item{surdays}{survival days for each patient}

\item{event}{indictor variable 1 represent patient died 0 represent patient survive}
}
\value{
a vector of cutoff points that maximize the Z statistics for cox model between each Diagnosis/Procedure A to another Diagnosis/Procedure B
}
\description{
Performs Cox proportional hazards regression model on patients survival days based on different cutoffs
}
\details{
Building and draw personized disease network
}
\examples{
comorbidity_data
survival_data
#Select a subset of data for toy example
comorbidity_data = comorbidity_data[c(1:10),]
survival_data = survival_data[c(1:10),]
k1 = datecut(comorbidity_data,survival_data[,1],survival_data[,2])
}
