% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{centroids_subtype}
\alias{centroids_subtype}
\title{Predict the subtypes of selected cancer type based published papers}
\usage{
centroids_subtype(data, disease = "LUSC")
}
\arguments{
\item{data}{data set to predict the subtypes which is a numeric matrix with row names of features and column names of samples}

\item{disease}{character string of the disease to predict subtypes, currently support 'LUSC', 'LUAD'}
}
\value{
an object of class "SubtypeClass" with four slots: genes used for predictiong, predicted subtypes of samples, a matrix of predicting scores, and the method.
}
\description{
Predict the subtypes of selected cancer type based published papers
}
\examples{
\dontrun{
library(OncoSubtype)
data <- get_median_centered(example_fpkm)
data <- assays(data)$centered
rownames(data) <- rowData(example_fpkm)$external_gene_name
centroids_subtype(data, disease = 'HNSC')
}
}
