% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_data.R
\name{raw_data}
\alias{raw_data}
\title{Download Open Case Study Raw Data}
\usage{
raw_data(casestudy, outpath = NULL)
}
\arguments{
\item{casestudy}{character string, name of the case study to pull data from.
The input name should follow the same naming scheme as the repository on GitHub:

ocs-bp-rural-and-urban-obesity

ocs-bp-air-pollution

ocs-bp-vaping-case-study

ocs-bp-opioid-rural-urban

ocs-bp-RTC-wrangling

ocs-bp-RTC-analysis

ocs-bp-youth-disconnection

ocs-bp-youth-mental-health

ocs-bp-school-shootings-dashboard

ocs-bp-co2-emissions

ocs-bp-diet}

\item{outpath}{character string, path to the directory where the downloaded
data folder should be saved.}
}
\value{
If download is successful, the path to the downloaded data folder is
printed and the logical value TRUE is returned. Otherwise the appropriate error message is printed.
}
\description{
Download the specified case study raw data to use as you follow along the case study.
}
\details{
This function downloads the Open Case Study raw data
from GitHub and saves it in a new 'OCS_data/data/raw/' folder in
the specified directory. This makes it so all the raw data
are easily available in a local folder to be processed and wrangled.
}
\examples{
tmp = tempfile()
dir.create(tmp)
raw_data('ocs-bp-opioid-rural-urban', outpath = tmp)

}
